/**
 * type: 0||false=> Ler 1||true=> Definir
 *
 */
var commands = {
  CUSTOM: function (type, val, num) {
    return {
      name: "Executar comando" + num,
      cmd: "AT^GT_CM=" + val,
    };
  },
  IMEI: function (type, val) {
    if (type) {
      return {
        name: "Escrever IMEI",
        cmd: "AT^GT_CM=IMEI," + val + "#",
      };
    } else {
      return {
        name: "Ler IMEI",
        cmd: "AT^GT_CM=IMEI#",
      };
    }
  },
  ICCID: function () {
    return {
      name: "Ler ICCID",
      cmd: "AT^GT_CM=ICCID#",
    };
  },
  CXZT: function () {
    return {
      name: "Ler CXZT",
      cmd: "AT^GT_CM=CXZT#",
    };
  },
  STATUS: function () {
    return {
      name: "Ler STATUS",
      cmd: "AT^GT_CM=STATUS#",
    };
  },
  RESET: function () {
    return {
      name: "Ler RESET",
      cmd: "AT^GT_CM=RESET#",
    };
  },
  GMT: function (type, A, B, C) {
    if (type) {
      return {
        name: "Escrever GMT",
        cmd: "AT^GT_CM=GMT," + A + "," + B + "," + C + "#",
      };
    } else {
      return {
        name: "Ler GMT",
        cmd: "AT^GT_CM=GMT#",
      };
    }
  },

  APN: function (type, APN0, APN1, APN2) {
    if (type) {
      return {
        name: "Escrever APN",
        cmd: "AT^GT_CM=APN," + APN0 + "," + APN1 + "," + APN2 + "#",
      };
    } else {
      return {
        name: "Ler APN",
        cmd: "AT^GT_CM=APN#",
      };
    }
  },
  SOSALM: function (type, val, it) {
    if (type) {
      // Definir
      if (val == 1) {
        if (it == 0) {
          return {
            name: "Ativar modo de alarme SOS 0",
            cmd: "AT^GT_CM=SOSALM,ON,0#",
          };
        }
        if (it == 1) {
          return {
            name: "Ativar modo de alarme SOS 1",
            cmd: "AT^GT_CM=SOSALM,ON,1#",
          };
        }
        if (it == 2) {
          return {
            name: "Ativar modo de alarme SOS 2",
            cmd: "AT^GT_CM=SOSALM,ON,2#",
          };
        }
      }
      if (val == 0) {
        return {
          name: "Desativar alarme SOS",
          cmd: "AT^GT_CM=SOSALM,OFF#",
        };
      }
    } else {
      // Ler
      return {
        name: "Ler alarme SOS",
        cmd: "AT^GT_CM=SOSALM#",
      };
    }
  },
  SOSR: function () {
    return {
      name: "Ler número SOS",
      cmd: "AT^GT_CM=SOS#",
    };
  },
  CENTERR: function () {
    return {
      name: "Ler número central",
      cmd: "AT^GT_CM=CENTER#",
    };
  },
  // Adicionar número SOS
  SOS: function (type, SOS0, SOS1, SOS2) {
    if (type) {
      return {
        name: "Adicionar número SOS",
        cmd: "AT^GT_CM=SOS,A," + SOS0 + "," + SOS1 + "," + SOS2 + "#",
      };
    } else {
      return {
        name: "Ler número SOS",
        cmd: "AT^GT_CM=SOS#",
      };
    }
  },
  // Adicionar número SOS
  SOSD: function (type, SOS0, SOS1, SOS2) {
    if (type) {
      return {
        name: "Remover número SOS",
        cmd: "AT^GT_CM=SOS,D," + SOS0 + "," + SOS1 + "," + SOS2 + "#",
      };
    } else {
      return {
        name: "Ler número SOS",
        cmd: "AT^GT_CM=SOS#",
      };
    }
  },
  // Número central
  CENTER1: function (type, CENTER) {
    if (type) {
      return {
        name: "Adicionar número central 1",
        cmd: "AT^GT_CM=CENTER,A," + CENTER + "#",
      };
    } else {
      return {
        name: "Ler número central",
        cmd: "AT^GT_CM=CENTER#",
      };
    }
  },
  CENTER2: function (type, CENTER) {
    if (type) {
      return {
        name: "Adicionar número central 2",
        cmd: "AT^GT_CM=CENTER,A2," + CENTER + "#",
      };
    } else {
      return {
        name: "Ler número central",
        cmd: "AT^GT_CM=CENTER#",
      };
    }
  },

  CENTER3: function (type, CENTER) {
    if (type) {
      return {
        name: "Adicionar número central",
        cmd: "AT^GT_CM=CENTER,A3," + CENTER + "#",
      };
    } else {
      return {
        name: "Ler número central",
        cmd: "AT^GT_CM=CENTER#",
      };
    }
  },
  CENTERD1: function (type, CENTERD) {
    if (type && CENTERD) {
      return {
        name: "Remover número central 1",
        cmd: "AT^GT_CM=CENTER,D#",
      };
    } else {
      return {
        name: "Ler número central",
        cmd: "AT^GT_CM=CENTER#",
      };
    }
  },
  CENTERD2: function (type, CENTERD) {
    if (type && CENTERD) {
      return {
        name: "Remover número central 2",
        cmd: "AT^GT_CM=CENTER,D2#",
      };
    } else {
      return {
        name: "Ler número central",
        cmd: "AT^GT_CM=CENTER#",
      };
    }
  },
  CENTERD3: function (type, CENTERD) {
    if (type && CENTERD) {
      return {
        name: "Remover número central 3",
        cmd: "AT^GT_CM=CENTER,D3#",
      };
    } else {
      return {
        name: "Ler número central",
        cmd: "AT^GT_CM=CENTER#",
      };
    }
  },
  TIMER: function (type, T1, T2) {
    if (type) {
      return {
        name: "Definir intervalo de envio de dados GPS",
        cmd: "AT^GT_CM=TIMER," + T1 + "," + T2 + "#",
      };
    } else {
      return {
        name: "Ler intervalo de envio de dados GPS",
        cmd: "AT^GT_CM=TIMER#",
      };
    }
  },
  SPEED: function (type, A, B, C, M) {
    if (type) {
      if (A === "1") {
        return {
          name: "Ativar configuração de alarme de velocidade excessiva",
          cmd: "AT^GT_CM=SPEED,ON," + B + "," + C + "," + M + "#",
        };
      }
      if (A + "" === "0") {
        return {
          name: "Desativar alarme de velocidade excessiva",
          cmd: "AT^GT_CM=SPEED,OFF#",
        };
      }
    } else {
      return {
        name: "Ler estado da configuração de velocidade excessiva",
        cmd: "AT^GT_CM=SPEED#",
      };
    }
  },
  SERVERNAME: function (type, name, port) {
    if (type) {
      return {
        name: "Configurar nome do servidor",
        cmd: "AT^GT_CM=SERVER,1," + name + "," + port + ",0#",
      };
    } else {
      return {
        name: "Ler configurações do servidor",
        cmd: "AT^GT_CM=SERVER#",
      };
    }
  },
  SERVERIP: function (type, name, port) {
    if (type) {
      return {
        name: "Configurar IP do servidor",
        cmd: "AT^GT_CM=SERVER,0," + name + "," + port + ",0#",
      };
    } else {
      return {
        name: "Ler configurações do servidor",
        cmd: "AT^GT_CM=SERVER#",
      };
    }
  },
  GT06: function (type, value) {
    if (type) {
      return {
        name: "Configurar protocolo da plataforma GT06",
        cmd: "AT^GT_CM=SZCS#GT06SEL=" + value + "#",
      };
    } else {
      return {
        name: "Ler protocolo da plataforma GT06",
        cmd: "AT^GT_CM=SZCS#GT06SEL#",
      };
    }
  },
  IEXVOL: function (type, value) {
    if (type) {
      return {
        name: "Configurar relatório de tensão externa",
        cmd: "AT^GT_CM=SZCS#GT06IEXVOL" + value + "#",
      };
    } else {
      return {
        name: "Ler relatório de tensão externa",
        cmd: "AT^GT_CM=SZCS#GT06IEXVOL#",
      };
    }
  },

  DORMANCY: function (type, value) {
    if (type) {
      return {
        name: "Configurar intervalo de envio de ponto estático",
        cmd: "AT^GT_CM=DORMANCY," + value + "#",
      };
    } else {
      return {
        name: "Ler intervalo de envio de ponto estático",
        cmd: "AT^GT_CM=DORMANCY#",
      };
    }
  },
  STA_SENDGPS: function (type, sw) {
    if (type) {
      return {
        name: "Configurar interruptor de envio de ponto estático",
        cmd: "AT^GT_CM=STA_SENDGPS," + sw + "#",
      };
    } else {
      return {
        name: "Ler intervalo de envio de ponto estático",
        cmd: "AT^GT_CM=DORMANCY#",
      };
    }
  },
  VERSION: function () {
    return {
      name: "Ler número da versão",
      cmd: "AT^GT_CM=VERSION#",
    };
  },
  VERSION: function (type, value) {
    if (type) {
      return {
        name: "Configurar versão",
        cmd: "AT^GT_CM=SETCO=" + value + "#",
      };
    } else {
      return {
        name: "Ler versão",
        cmd: "AT^GT_CM=Version# ",
      };
    }
  },
};
